/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取控制芯片列表/显示芯片列表/行管芯片列表
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.3.11
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_edit_get_hub_config */
/* exported mc_modwizd_dispchip_register_info_by_sdk */
/* exported mc_modwizd_access_set_box_file */
/* exported mc_send_box_basic_date */
/* exported mc_redirect_box_date_to_hardware */
/* exported mc_scan_dispatch_pixel_control_information_to_hardware */
/* exported mc_modwizd_access_set_mod_file */
/* exported mc_set_gray_number */
/* exported mc_edit_module_str_len_min */

/* global mc_sdk_param */
/* global mc_sdk_hub */
/* global mc_sdk_module */
/* global mc_sdk_recvcard */
/* global $ */

var JSON_PAPRAM_GET = "GET_PARAM";
var JSON_PAPRAM_SET = "SET_PARAM";
var obj_sdk_param_req = new mc_sdk_param();

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取箱体或者模组数据下标
 * 参数:
 *    @param {Promise<String>} data_name 箱体名称/模组名称
 *    @param {Promise<Array>} ary_data 箱体数据数组/模组数据数组
 * 返回：
 *    @returns {Promise<Uint>} 对应名称的数据下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-4-13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_get_data_idx(data_name, ary_data) {
    if ("string" !== typeof data_name || 0 >= data_name.length) {
        return false;
    }
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    for (var idx = 0; idx < ary_data.length; idx++) {
        if (data_name === ary_data[idx].name) {
            return idx;
        }
    }
    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取默认hub列表
 * 参数:
 *    @param {Promise<String>} str_ctrlchip_name 主控芯片名称
 *    @param {Promise<String>} str_hub_name hub接口名称
 *    @param {Promise<String>} fun_callback 接收数据的回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-3-11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_get_hub_config(str_ctrlchip_name, str_hub_name, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_hub_name || 0 >= str_hub_name.length) {
        fun_callback();
        return;
    }

    mc_edit_get_hub_list_by_sdk(str_ctrlchip_name, str_hub_name, function (str_xml_res) {
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_json(str_xml_res);

        // var str_hub_xml = obj_sdk_param.get_param_value(str_ctrlchip_name);
        var str_hub_xml = obj_sdk_param.get_attr_val(str_ctrlchip_name, "DATA");
        var obj_sdk_hub = new mc_sdk_hub();

        obj_sdk_hub.set_hub_xml(str_hub_xml);
        var obj_edit_val = obj_sdk_hub.get_hub_msg();

        if (!obj_edit_val.str_name) {
            var ary_defualt_dat = [];

            for (var idx = 0; 256 > idx; idx++) {
                ary_defualt_dat.push(idx);
            }
            obj_edit_val = {
                str_name: str_hub_name,
                str_iccount: "1",
                str_all_use_dat_cnt: "256",
                ary_child_pin: [{
                    str_subname: "A",
                    str_use_dat_pin_count: "256",
                    str_use_ctl_pin_count: "0",
                    str_dat_pin_cnt: "256",
                    ary_st_dat: ary_defualt_dat,
                    ary_st_ctl: []
                }]

            };
        }
        fun_callback(obj_edit_val);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    向sdk请求Hub描述信息
 * 参数:
 *    @param {Promise<String>} str_ctrlchip_name 控制芯片名称
 *    @param {Promise<String>} str_hub_name Hub名称
 *    @param {Promise<String>} fun_callback 接收数据的回调函数
 * 返回：
 *    N
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-3-11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_get_hub_list_by_sdk(str_ctrlchip_name, str_hub_name, fun_callback) {
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_cmd(JSON_PAPRAM_GET);
    obj_sdk_param.set_func("RECVCARD_HUB_FILE");
    obj_sdk_param.set_param_value(str_ctrlchip_name, str_hub_name);
    $.post("/access_shell", obj_sdk_param.get_json(), function (response, stars) {
        if ("success" !== stars) {
            fun_callback(false);
            return;
        }
        fun_callback(response);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应模组颜色
 * 参数:
 *    @param {Promise<String>} mod_name 模组名称
 *    @param {Promise<String>} ary_mod_data 模组数据数组
 * 返回：
 *    @returns {promises<string>} 颜色
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-3-11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_get_mod_clr(mod_name, ary_mod_data) {
    if ("string" !== typeof mod_name || 0 >= mod_name.length) {
        return "RGB";
    }
    if (!Array.isArray(ary_mod_data)) {
        return "RGB";
    }
    var str_clr_req = "RGB";
    var str_clr_res = "";

    //如果对应Modlist下第一个模组存在 则添加相应颜色 如果没有 则添加上一个模组的颜色


    var ui_mod_idx = mc_edit_get_data_idx(mod_name, ary_mod_data);

    if (0 !== ui_mod_idx && !ui_mod_idx) {
        return "RGB";
    }
    var obj_sdk_module = ary_mod_data[ui_mod_idx].data;
    var ui_grop_mod = obj_sdk_module.mc_util_mod_get_str_grp_mode();
    // var ui_merge_mod_cnt = ary_mod_data[ui_mod_idx].merge;

    // if (0 < ui_merge_mod_cnt) {
    //     ui_grop_mod *= ui_merge_mod_cnt;
    // }

    for (var idx_grp = 0; idx_grp < ui_grop_mod; idx_grp++) {
        str_clr_res += obj_sdk_module.mc_util_mod_get_str_color(idx_grp);
    }
    if (-1 !== str_clr_res.indexOf(",")) {
        var str_clr = "";

        for (var idx_str = 0; idx_str < str_clr_res.length; idx_str++) {
            if ("," !== str_clr_res[idx_str]) {
                str_clr += str_clr_res[idx_str];
            }
        }
        str_clr_res = str_clr;
    }
    str_clr_req = str_clr_res;
    return str_clr_req;
}

/********** EXPORT API *********************************************************************************/

/* exported mc_edit_get_hub_config_for_ui */
/* exported mc_edit_get_mod_clr_for_ui */
/* exported mc_edit_set_edit_for_box */
/* exported mc_edit_text_box */

/**
 * @param {promises<string>} str_ctrlchip_name 主控芯片名称
 * @param {promises<string>} str_hub_name hub接口名称
 * @param {promises<Function>} fun_callback 接收数据的回调函数
 **/

function mc_edit_get_hub_config_for_ui(str_ctrlchip_name, str_hub_name, fun_callback) {
    return mc_edit_get_hub_config(str_ctrlchip_name, str_hub_name, fun_callback);
}

/**
 * @param {promises<string>} mod_name 模组名称
 * @param {promises<string>} ary_mod_data 模组数据数组
 * @returns {promises<string>} 颜色
 **/
function mc_edit_get_mod_clr_for_ui(mod_name, ary_mod_data) {
    return mc_edit_get_mod_clr(mod_name, ary_mod_data);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取显示芯片注册信息
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 控制芯片名称,不能为空
 *    @param {Promise<string>} str_dispchip 显示芯片名称,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_dispchip_register_info_by_sdk(str_ctrlchip, str_dispchip, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback("");
        return;
    }
    if ("string" !== typeof str_dispchip || 0 >= str_dispchip.length) {
        fun_callback("");
        return;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_cmd(JSON_PAPRAM_GET);
    str_item_json_req.set_func("DISPCHIP_INFO");
    str_item_json_req.set_param_value(str_dispchip, "");
    str_item_json_req.set_attr_val(str_dispchip, "CTRLCHIP", str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback(response);
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置模组信息
 * 参数:
 *    @param {Promise<string>} str_module_name 模组名称
 *    @param {Promise<string>} str_module_xml_txt 模组信息xml子串
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_access_set_mod_file(str_module_name, str_module_xml_txt, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_module_name || 0 >= str_module_name.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_module_xml_txt || 0 >= str_module_xml_txt.length) {
        fun_callback();
        return;
    }
    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("MOD_FILE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value(str_module_name, str_module_xml_txt);
    obj_sdk_param_req.set_attr_val(str_module_name, "FILE_OPT", "SET");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置箱体链接信息
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 参数字串 控制芯片名称,不能为空
 *    @param {Promise<string>} str_mod_name 参数子串 模组名称
 *    @param {Promise<string>} str_hub_name Hub名称
 *    @param {Promise<string>} str_module_xml 参数子串 模组描述xml
 *    @param {Promise<string>} str_connect 连接字串
 *    @param {Promise<object>} fun_callback 完成设置后回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_access_set_box_file(str_ctrlchip, str_mod_name, str_hub_name, str_module_xml, str_connect, fun_callback) {
    if ("function" !== typeof fun_callback || "string" !== typeof str_connect || 0 === str_connect.length) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback();
        return;
    }
    if ("string" !== typeof str_module_xml || 0 >= str_module_xml.length) {
        fun_callback();
        return;
    }
    var obj_sdk_module = new mc_sdk_module();

    obj_sdk_module.mc_util_mod_reset();
    obj_sdk_module.mc_util_mod_set_xml(str_module_xml);
    var ui_str_cnt = obj_sdk_module.mc_util_mod_get_str_cnt();
    var str_recvcard_xml = new mc_sdk_recvcard();
    var str_recvcard_xml_txt = "";

    str_recvcard_xml.mc_util_recvcard_set_ctrlchip_name(str_ctrlchip);
    str_recvcard_xml.mc_util_recvcard_set_hub_name(str_hub_name);
    str_recvcard_xml.mc_util_recvcard_set_hub_dsp(str_connect);
    str_recvcard_xml.mc_util_recvcard_set_modlist_mod_info(0, 0, str_mod_name, 0, 0);
    var str_pin_id = "";
    var str_dsp_val = "";

    for (var idx_dsp = 0; idx_dsp < ui_str_cnt; idx_dsp++) {
        str_pin_id = obj_sdk_module.mc_util_mod_get_str_pin(idx_dsp);
        str_dsp_val += "(DSP" + idx_dsp + ":" + str_pin_id + "),";
    }
    str_recvcard_xml.mc_util_recvcard_set_modlist_pin_pair_exp(0, str_dsp_val.substring(0, str_dsp_val.length - 1));
    str_recvcard_xml_txt = str_recvcard_xml.mc_util_recvcard_get_xml();
    mc_modwizd_set_box_file_to_sdk(str_recvcard_xml_txt, fun_callback);
}

function mc_modwizd_set_box_file_to_sdk(str_recvcard_xml_txt, fun_callback) {
    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("BOX_FILE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value("mc_test_box", str_recvcard_xml_txt);
    obj_sdk_param_req.set_attr_val("mc_test_box", "FILE_OPT", "SET");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            fun_callback();
            return;
        }
        fun_callback();
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体基础数据
 * 参数:
 *    @param {Promise<function>} fun_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.3.18
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_box_basic_date(fun_callback) {
    var basic_date_val = "(" + "0" + ":" + "0" + ":" + "-1" + ":" + "-1" + ":" + "0" + ")";

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("HW_BOX_BASE");
    obj_sdk_param_req.set_cmd(JSON_PAPRAM_SET);
    obj_sdk_param_req.set_param_value("RECVCARD", basic_date_val);
    obj_sdk_param_req.set_attr_val("RECVCARD", "BOX_NAME", "mc_test_box");
    var str_workmode = "0";

    if (parent.b_if_mass) {
        str_workmode = "1";
    }
    // obj_sdk_param_req.set_attr_val("RECVCARD", "WORKMODE", str_workmode);

    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        fun_callback();
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体灯串显示数据重定向
 * 参数:
 *    @param {Promise<String>} str_param_val
 *    @param {Promise<String>} str_attr_val
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_redirect_box_date_to_hardware(str_param_val, str_attr_val, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    var str_item_obj_req = new mc_sdk_param();

    str_item_obj_req.set_param_clear();
    str_item_obj_req.set_func("DSP_REDIRECT");
    str_item_obj_req.set_cmd(JSON_PAPRAM_SET);
    str_item_obj_req.set_param_value("mc_test_box", str_param_val);
    str_item_obj_req.set_attr_val("mc_test_box", "CMD", str_attr_val);
    $.post("/access_shell", str_item_obj_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback();
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体像素控制信息
 * 参数:
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_scan_dispatch_pixel_control_information_to_hardware(fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    var str_item_obj_req = new mc_sdk_param();
    var str_param_val = "(0:0:-1:-1:-1)";
    var str_attr_val = "(255:0:-1:-1),(0:1:-1:-1)";

    str_item_obj_req.set_param_clear();
    str_item_obj_req.set_func("PIX_SWITCH");
    str_item_obj_req.set_cmd(JSON_PAPRAM_SET);
    str_item_obj_req.set_param_value("mc_test_box", str_param_val);
    str_item_obj_req.set_attr_val("mc_test_box", "CMD", str_attr_val);
    $.post("/access_shell", str_item_obj_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    修改灰阶度为4 只适用于本文件的html
 * 参数:
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.03.25
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_gray_number(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_func("NORMAL");
    obj_sdk_param_req.set_cmd("SET_PARAM");
    obj_sdk_param_req.set_param_value("GRAY_BIT_SIZE", "4");
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (_response, status) {
        if ("success" !== status) {
            fun_callback();
            return;
        }

        fun_callback();
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    确保STR条数不小于两条
 * 参数:
 *    @param {Promise<string>} stri_moduel_xml 模组xml字串
 * 返回：
 *    @return { Promise<string> } 模组xml字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.03.31
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_edit_module_str_len_min(stri_moduel_xml) {
    if ("string" !== typeof stri_moduel_xml || 0 >= stri_moduel_xml.length) {
        return false;
    }
    var obj_sdk_module = new mc_sdk_module();

    obj_sdk_module.mc_util_mod_reset();
    obj_sdk_module.mc_util_mod_set_xml(stri_moduel_xml);
    var ui_str_cnt = obj_sdk_module.mc_util_mod_get_str_cnt();

    if (2 <= ui_str_cnt) {
        return obj_sdk_module.mc_util_mod_get_xml();
    }
    obj_sdk_module.mc_util_mod_set_str_pin(1, "STR_1");
    obj_sdk_module.mc_util_mod_set_str_name(1, "STR_1");
    return obj_sdk_module.mc_util_mod_get_xml();
}
